/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanModel;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.CustomCarriedBlockLayer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.CustomEnderEyesLayer;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;

public class BaseEndermanEntityRenderer<T extends BaseEnderman>
extends GeoEntityRenderer<T> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("endermanoverhaul", "enderman");
    public static final ResourceLocation ICE_SPIKES_ANIMATION = new ResourceLocation("endermanoverhaul", "ice_spikes_enderman");
    public static final ResourceLocation SNOWY_ANIMATION = new ResourceLocation("endermanoverhaul", "snowy_enderman");
    public static final ResourceLocation DESERT_ANIMATION = new ResourceLocation("endermanoverhaul", "desert_enderman");
    public static final ResourceLocation SOULSAND_VALLEY_ANIMATION = new ResourceLocation("endermanoverhaul", "soulsand_valley_enderman");
    public static final ResourceLocation END_ANIMATION = new ResourceLocation("endermanoverhaul", "end_enderman");
    public static final ResourceLocation FLOWER_FIELDS_ANIMATION = new ResourceLocation("endermanoverhaul", "flower_fields_enderman");
    public static final ResourceLocation END_ISLANDS_ANIMATION = new ResourceLocation("endermanoverhaul", "end_islands_enderman");
    public static final ResourceLocation WARPED_FOREST_ANIMATION = new ResourceLocation("endermanoverhaul", "warped_forest_enderman");
    public static final ResourceLocation OCEAN_ANIMATION = new ResourceLocation("endermanoverhaul", "ocean_enderman");
    public static final ResourceLocation DARK_OAK_ANIMATION = new ResourceLocation("endermanoverhaul", "dark_oak_enderman");
    public static final ResourceLocation WINDSWEPT_HILLS_ANIMATION = new ResourceLocation("endermanoverhaul", "windswept_hills_enderman");

    public BaseEndermanEntityRenderer(EntityRendererProvider.Context renderManager, EntityType<?> enderman) {
        this(renderManager, enderman, ANIMATION);
    }

    public BaseEndermanEntityRenderer(EntityRendererProvider.Context renderManager, EntityType<?> enderman, ResourceLocation animation) {
        this(renderManager, enderman, animation, true);
    }

    public BaseEndermanEntityRenderer(EntityRendererProvider.Context renderManager, EntityType<?> enderman, ResourceLocation animation, boolean turnsHead) {
        this(renderManager, Registry.f_122826_.m_7981_(enderman), BaseEndermanEntityRenderer.getTexture(enderman), animation, BaseEndermanEntityRenderer.getGlowTexture(enderman), turnsHead);
    }

    public BaseEndermanEntityRenderer(EntityRendererProvider.Context renderManager, ResourceLocation assetPath, ResourceLocation texture, ResourceLocation animation, ResourceLocation glow, boolean turnsHead) {
        super(renderManager, new BaseEndermanModel(assetPath, turnsHead, texture, animation));
        if (glow != null) {
            this.addLayer(new CustomEnderEyesLayer(this, glow));
        }
        this.addLayer(new CustomCarriedBlockLayer(this, renderManager.m_234597_(), () -> (EnderMan)this.animatable));
    }

    public BaseEndermanEntityRenderer(EntityRendererProvider.Context renderManager, BaseEndermanModel<T> model) {
        super(renderManager, model);
    }

    @NotNull
    public Vec3 getRenderOffset(T entity, float partialTicks) {
        if (entity.m_32531_() && ((BaseEnderman)((Object)entity)).canShake()) {
            Level level = ((BaseEnderman)((Object)entity)).f_19853_;
            return new Vec3(level.f_46441_.m_188583_() * 0.02, 0.0, level.f_46441_.m_188583_() * 0.02);
        }
        return super.m_7860_(entity, partialTicks);
    }

    public RenderType getRenderType(T animatable, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    public static ResourceLocation getTexture(EntityType<?> enderman) {
        String name = Registry.f_122826_.m_7981_(enderman).m_135815_();
        return new ResourceLocation("endermanoverhaul", "%s/%s".formatted(name.replace("_enderman", ""), name));
    }

    public static ResourceLocation getGlowTexture(EntityType<?> enderman) {
        String name = Registry.f_122826_.m_7981_(enderman).m_135815_();
        return new ResourceLocation("endermanoverhaul", "textures/entity/%s/%s_glow.png".formatted(name.replace("_enderman", ""), name));
    }
}

